


<?php $__env->startSection('title', 'Gestión de Personas'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">👥 Gestión de Personas</h1>
            <p class="text-gray-600 mt-1">Administración de clientes y trabajadores</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('personas.crear')): ?>
        <a href="<?php echo e(route('colaborador.personas.create')); ?>" 
           class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg shadow transition">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
            </svg>
            Registrar Persona
        </a>
        <?php endif; ?>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow mb-6 p-6">
        <form method="GET" action="<?php echo e(route('colaborador.personas.index')); ?>" class="space-y-4">
            <!-- Primera fila -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">🔍 Buscar</label>
                    <input type="text" 
                           name="buscar" 
                           value="<?php echo e(request('buscar')); ?>"
                           placeholder="Documento, nombre, apellido..."
                           class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">👤 Tipo de Persona</label>
                    <select name="tipo_persona" id="tipo_persona_filter" class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Todos</option>
                        <option value="colaborador" <?php echo e(request('tipo_persona') == 'colaborador' ? 'selected' : ''); ?>>
                            👔 Trabajador
                        </option>
                        <option value="cliente" <?php echo e(request('tipo_persona') == 'cliente' ? 'selected' : ''); ?>>
                            👥 Cliente
                        </option>
                    </select>
                </div>

                <div class="flex gap-2 items-end">
                    <button type="submit" class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition">
                        🔍 Filtrar
                    </button>
                    <a href="<?php echo e(route('colaborador.personas.index')); ?>" class="px-4 py-2 bg-gray-200 hover:bg-gray-300 text-gray-700 rounded-lg transition">
                        🔄
                    </a>
                    <button type="button" onclick="exportData()" class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg transition" title="Exportar">
                        📊
                    </button>
                </div>
            </div>

            <!-- Segunda fila - Filtros solo para colaboradores -->
            <div id="filtros-colaborador" class="grid grid-cols-1 md:grid-cols-4 gap-4 pt-4 border-t <?php echo e(request('tipo_persona') == 'colaborador' || !request('tipo_persona') ? '' : 'hidden'); ?>">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">🏢 Dirección</label>
                    <select name="direccion_id" class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $direcciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $direccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($direccion->id_direcciones); ?>" <?php echo e(request('direccion_id') == $direccion->id_direcciones ? 'selected' : ''); ?>>
                            <?php echo e($direccion->nombre_direcciones); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">🏛️ Dependencia</label>
                    <select name="dependencia_id" class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $dependencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dependencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dependencia->id_dependencias); ?>" <?php echo e(request('dependencia_id') == $dependencia->id_dependencias ? 'selected' : ''); ?>>
                            <?php echo e($dependencia->nombre_dependencia); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">📁 Área</label>
                    <select name="area_id" class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($area->id_area); ?>" <?php echo e(request('area_id') == $area->id_area ? 'selected' : ''); ?>>
                            <?php echo e($area->nombre_area); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">💼 Cargo</label>
                    <select name="cargo_id" class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Todos</option>
                        <?php $__currentLoopData = $cargos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cargo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cargo->id_cargos); ?>" <?php echo e(request('cargo_id') == $cargo->id_cargos ? 'selected' : ''); ?>>
                            <?php echo e($cargo->nombre_cargo); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </form>
    </div>

    <!-- Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">Total Personas</p>
                    <p class="text-2xl font-bold text-blue-600"><?php echo e($stats['total']); ?></p>
                </div>
                <div class="p-3 bg-blue-100 rounded-full">
                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">👔 Trabajadores</p>
                    <p class="text-2xl font-bold text-green-600"><?php echo e($stats['colaboradores']); ?></p>
                </div>
                <div class="p-3 bg-green-100 rounded-full">
                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">👥 Clientes</p>
                    <p class="text-2xl font-bold text-purple-600"><?php echo e($stats['clientes']); ?></p>
                </div>
                <div class="p-3 bg-purple-100 rounded-full">
                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de Personas -->
    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Persona
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Documento
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Tipo
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Información
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Contacto
                    </th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Acciones
                    </th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $personas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $persona): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-10 w-10">
                                <div class="h-10 w-10 rounded-full bg-gradient-to-r from-blue-500 to-blue-600 flex items-center justify-center text-white font-bold">
                                    <?php echo e(substr($persona->nombres, 0, 1)); ?><?php echo e(substr($persona->apellido_paterno, 0, 1)); ?>

                                </div>
                            </div>
                            <div class="ml-4">
                                <div class="text-sm font-medium text-gray-900">
                                    <?php echo e($persona->apellido_paterno); ?> <?php echo e($persona->apellido_materno); ?>

                                </div>
                                <div class="text-sm text-gray-500">
                                    <?php echo e($persona->nombres); ?>

                                </div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900"><?php echo e($persona->tipo_documento); ?></div>
                        <div class="text-sm text-gray-500"><?php echo e($persona->num_documento); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <?php if($persona->tipo_persona == 'colaborador'): ?>
                            <span class="px-2 py-1 text-xs bg-blue-100 text-blue-800 rounded-full font-semibold">
                                👔 Trabajador
                            </span>
                        <?php else: ?>
                            <span class="px-2 py-1 text-xs bg-purple-100 text-purple-800 rounded-full font-semibold">
                                👥 Cliente
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 text-sm">
                        <?php if($persona->tipo_persona == 'colaborador' && $persona->colaborador): ?>
                            <div class="space-y-1">
                                <?php if($persona->colaborador->direccion): ?>
                                    <div class="text-xs text-gray-600">🏢 <?php echo e($persona->colaborador->direccion->nombre_direcciones); ?></div>
                                <?php endif; ?>
                                <?php if($persona->colaborador->dependencia): ?>
                                    <div class="text-xs text-gray-600">🏛️ <?php echo e($persona->colaborador->dependencia->nombre_dependencia); ?></div>
                                <?php endif; ?>
                                <?php if($persona->colaborador->area): ?>
                                    <div class="text-xs text-gray-600">📁 <?php echo e($persona->colaborador->area->nombre_area); ?></div>
                                <?php endif; ?>
                                <?php if($persona->colaborador->cargo): ?>
                                    <div class="text-xs font-medium text-gray-800">💼 <?php echo e($persona->colaborador->cargo->nombre_cargo); ?></div>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <?php if($persona->direccion): ?>
                                <div class="text-xs text-gray-600">📍 <?php echo e(Str::limit($persona->direccion, 50)); ?></div>
                            <?php else: ?>
                                <span class="text-xs text-gray-400">Sin información</span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm">
                            <?php if($persona->correo): ?>
                                <div class="text-xs text-gray-600 mb-1">✉️ <?php echo e(Str::limit($persona->correo, 25)); ?></div>
                            <?php endif; ?>
                            <?php if($persona->telefono): ?>
                                <div class="text-xs text-gray-600">📞 <?php echo e($persona->telefono); ?></div>
                            <?php endif; ?>
                            <?php if($persona->whatsapp): ?>
                                <div class="text-xs text-green-600">💬 <?php echo e($persona->whatsapp); ?></div>
                            <?php endif; ?>
                            <?php if(!$persona->correo && !$persona->telefono && !$persona->whatsapp): ?>
                                <span class="text-xs text-gray-400">Sin contacto</span>
                            <?php endif; ?>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                        <div class="flex justify-end gap-2">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('personas.ver')): ?>
                            <a href="<?php echo e(route('colaborador.personas.show', $persona)); ?>" 
                               class="text-blue-600 hover:text-blue-900" title="Ver">
                                👁️
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('personas.editar')): ?>
                            <a href="<?php echo e(route('colaborador.personas.edit', $persona)); ?>" 
                               class="text-yellow-600 hover:text-yellow-900" title="Editar">
                                ✏️
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('personas.eliminar')): ?>
                            <form method="POST" 
                                  action="<?php echo e(route('colaborador.personas.destroy', $persona)); ?>" 
                                  onsubmit="return confirm('¿Está seguro de eliminar esta persona?')"
                                  class="inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900" title="Eliminar">
                                    🗑️
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No hay personas registradas</h3>
                        <p class="mt-1 text-sm text-gray-500">Comienza registrando una nueva persona</p>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Paginación -->
    <?php if($personas->hasPages()): ?>
    <div class="mt-6">
        <?php echo e($personas->links()); ?>

    </div>
    <?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
// Mostrar/ocultar filtros de colaborador según tipo seleccionado
document.getElementById('tipo_persona_filter').addEventListener('change', function() {
    const filtrosColaborador = document.getElementById('filtros-colaborador');
    if (this.value === 'colaborador' || this.value === '') {
        filtrosColaborador.classList.remove('hidden');
    } else {
        filtrosColaborador.classList.add('hidden');
    }
});

function exportData() {
    const params = new URLSearchParams(window.location.search);
    window.location.href = '<?php echo e(route("colaborador.personas.export")); ?>?' + params.toString();
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.colaborador', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\resoluciones\resources\views/colaborador/personas/index.blade.php ENDPATH**/ ?>