<?php
// filepath: app/Models/Unidad.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Unidad extends Model
{
    use HasFactory;

    protected $table = 'unidad';
    protected $primaryKey = 'id_unidad';
    public $timestamps = false;

    protected $fillable = [
        'nombre_unidad',
        'id_usuario',
        'i_active'
    ];

    protected $casts = [
        'i_active' => 'boolean',
        'fecha_actualizacion' => 'datetime',
    ];

    public function getRouteKeyName()
    {
        return 'id_unidad';
    }

    // Relaciones
    public function usuario()
    {
        return $this->belongsTo(User::class, 'id_usuario');
    }

    public function colaboradores()
    {
        // ← CORREGIR: El foreign key en colaborador se llama id_unidades (plural)
        return $this->hasMany(Colaborador::class, 'id_unidades', 'id_unidad');
    }

    // Scopes
    public function scopeActivas($query)
    {
        return $query->where('i_active', true);
    }

    public function scopeBuscar($query, $search)
    {
        return $query->where('nombre_unidad', 'like', "%{$search}%");
    }
}